/*
 *  Copyright: Willem Hengeveld
 *
 *  original code from: 
 *    http://nah6.com/~itsme/cvs-xdadevtools/itsutils/leds/
 *
 *  Injector Copyright: Collin Mulliner <collin@mulliner.org>
 *
 *  injector code:
 *    http://www.mulliner.org/security/sms/
 *
 */

#include <windows.h>
#include <pkfuncs.h>
#include <kernel.h>
#include <commctrl.h>
#include <winsock.h>
#include <stdio.h>
#include <time.h>


// see
// c:/Program Files/Windows Mobile 6 SDK/PocketPC/Include/Armv4i/devload.h
#include <set>

#include "stringutils.h"
#include "devicedriverloader.h"
#include "RegistryFunctions.h"

#define BINLOGBUFFERSIZE 0x100000
#define TIMESTAMP_INTERVAL 10000

HANDLE log_mutex;

// 2 ways of connecting to the old device:
//    - DONE: via normal dev interface
//    - DONE: loaded as dll

// done: make attach unique id to each log entry, to make it easier to group them together in the log
// done: register as 'naked' device, to make it easier to add it as any kind of device.
// todo: added special ioctl, which saves/flushes all logs to disk
// todo: add 'merged' log option.
// todo: improve stream-logfile naming

/*
# rdo1 -> logdev
#      target=rdo2
# rdo2 -> radio
installdev: ../build/logdev.dll
	pput -f ../build/logdev.dll "%CSIDL_WINDOWS%"
	pregutl -c HKLM\\Drivers\\BuiltIn\\Thunkdev
	pregutl -s HKLM\\Drivers\\BuiltIn\\Thunkdev :Dll=sz:radio.dll :Index=dword:00000002 :Order=dword:00000002 :Prefix=sz:RDO :Priority256=dword:00000093
	pregutl -s HKLM\\Drivers\\BuiltIn\\QRADIO :Dll=sz:logdev.dll :target=sz:RDO2:

[HKLM\drivers\active\15]
BusName="BuiltInPhase1_0_1_0"
BusParent=dword:000323d0
Hnd=dword:0003d6c0
InterfaceType=dword:00000000
Key="Drivers\BuiltIn\Thunkdev"
Name="RDO2:"

[HKLM\Drivers\BuiltIn\Thunkdev]
Dll="radio.dll"
Index=dword:00000002
Order=dword:00000002
Prefix="RDO"
Priority256=dword:00000093

*/

// performance:
//
// (verbose=4,  target=drivers\builtin\thunkdev)
// c3800000 01800000 01800000 c3805000 00000008 virser_data.dll
// 6f1b2d32 01802cf0 95 95 8c095880 8c095880 08a4fe20   0.0   8.2                 afa17df2: device.exe 20
// c3880000 01880000 01880000 c3891000 00000008 radio.dll
// 8f937fca 01887e2c 5f 5f 8c095880 8c095880 083dfe1c   0.0   5.4                 afa17df2: device.exe 20
// ef910a4e 01887fac 67 67 8c095880 8c095880 0840fdf0   0.0   1.0                 afa17df2: device.exe 20
// c3940000 01940000 01940000 c394e000 00000008 wavedev.dll
// af826882 01947d2c 63 63 8c095880 8c095880 0859fe1c   0.0   5.5                 afa17df2: device.exe 20

// no logging device:
// c3800000 01800000 01800000 c3805000 00000008 virser_data.dll
// 2f02efa2 01802cf0 95 95 8c095880 8c095880 08a8fe20   0.0   0.6                 efa16df2: device.exe 20
// c3880000 01880000 01880000 c3891000 00000008 radio.dll
// 0f946fca 01887e2c 5f 5f 8c095880 8c095880 083bfe1c   0.0   2.8                 efa16df2: device.exe 20
// 0f926e62 01887fac 67 67 8c095880 8c095880 0840fdf0   0.0   0.8                 efa16df2: device.exe 20
// c3940000 01940000 01940000 c394e000 00000008 wavedev.dll
// 0f8399f6 01947d2c 63 63 8c095880 8c095880 0859fe1c   0.0   5.5                 efa16df2: device.exe 20

// (verbose=4, target=RDO2)
// c3800000 01800000 01800000 c3805000 00000008 virser_data.dll
// 8f3d72ae 01802cf0 95 95 8c095880 8c095880 08a3fe20   0.0   8.4                 afa1adf2: device.exe 20
// c3880000 01880000 01880000 c3891000 00000008 radio.dll
// 8f9618ba 01887e2c 5f 5f 8c095880 8c095880 0835fe1c   0.0   5.2                 afa1adf2: device.exe 20
// 6f92ae62 01887fac 67 67 8c095880 8c095880 0840fdf0   0.0   1.0                 afa1adf2: device.exe 20
// c3940000 01940000 01940000 c394e000 00000008 wavedev.dll
// cf83dab2 01947d2c 63 63 8c096188 8c096188 0859fe44   0.0   6.0                 afa1adf2: device.exe 20


// (verbose=0x14,  target=drivers\builtin\thunkdev)
// c3800000 01800000 01800000 c3805000 00000008 virser_data.dll
// 6e4a3f8a 01802cf0 95 95 8c095880 8c095880 0921fe20   0.0   2.5                 afa1adf2: device.exe 20
// c3880000 01880000 01880000 c3891000 00000008 radio.dll
// cf93bd3a 01887e2c 5f 5f 8c095880 8c095880 083cfe1c   0.0   5.3                 afa1adf2: device.exe 20
// 4f914936 01887fac 67 67 8c095880 8c095880 0840fdf0   0.0   0.8                 afa1adf2: device.exe 20
// c3940000 01940000 01940000 c394e000 00000008 wavedev.dll
// cf728576 01947d2c 63 63 8c095880 8c095880 086afe1c   0.0   5.8                 afa1adf2: device.exe 20

// (verbose=0x14,  target=drivers\builtin\thunkdev)
// c3800000 01800000 01800000 c3805000 00000008 virser_data.dll
// ceba1152 01802cf0 95 95 8c095880 8c095880 091efe20   0.0   0.8                 afa18df2: device.exe 20
// c3880000 01880000 01880000 c3891000 00000008 radio.dll
// ef933f22 01887e2c 5f 5f 8c095880 8c095880 083cfe1c   0.0   3.0                 afa18df2: device.exe 20
// 2f912936 01887fac 67 67 8c095880 8c095880 0840fdf0   0.0   0.8                 afa18df2: device.exe 20
// c3940000 01940000 01940000 c394e000 00000008 wavedev.dll
// 0f7255ba 01947d2c 63 63 8c095880 8c095880 086afe1c   0.0   5.6                 afa18df2: device.exe 20
//
// some notes:
//    Read's are usually from a reader-thread in virser_atcmd.dll or virser_data.dll
//    Write's are directly from threads in spcore or rilgsm
//
//-------------------------------------------------------------------
#define EXPORT __declspec(dllexport) 
extern "C" {
EXPORT DWORD Init( DWORD dwContext);
EXPORT BOOL Close( DWORD Handle);
EXPORT BOOL Deinit( DWORD dwContext);
EXPORT DWORD Open( DWORD dwData, DWORD dwAccess, DWORD dwShareMode);
EXPORT BOOL IOControl( DWORD Handle, DWORD dwIoControlCode, PBYTE pInBuf, DWORD nInBufSize, PBYTE pOutBuf, DWORD nOutBufSize, PDWORD pBytesReturned);
EXPORT DWORD Read(DWORD Handle, LPVOID pBuffer, DWORD dwNumBytes);
EXPORT DWORD Write(DWORD Handle, LPCVOID pBuffer, DWORD dwNumBytes);
EXPORT DWORD Seek(DWORD Handle, long lDistance, DWORD dwMoveMethod);
EXPORT void PowerUp(void);
EXPORT void PowerDown(void);
}



//-------------------------------------------------------------------

#define VERBOSE_IOCONTROL 1
#define VERBOSE_READWRITE 2
#define VERBOSE_BINARY 4
#define VERBOSE_FLUSHOFTEN 8     // buffers are flushed to disk either every write, or every 64 writes
#define VERBOSE_MEMBUFFER 0x10
#define VERBOSE_THREADINFO 0x20
// 1 : log iocontrol
// 2 : log read/write
// 4 : log binary
// 8 : flush every write
//10 : log to memorybuffer
//20 : log thread info
static DWORD verbose;

HANDLE hLog;
int nlogs;
void openlog()
{
    if (hLog!=NULL && hLog!=INVALID_HANDLE_VALUE)
        return;
    hLog= CreateFile(_T("\\logdev.log"), GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_ALWAYS, 0, NULL); 
    if (hLog==INVALID_HANDLE_VALUE) {
        hLog= NULL;
        OutputDebugString(_T("error opening logdev.log\n"));
    }
}
void closelog()
{
    CloseHandle(hLog);
    hLog=NULL;
}
void writelog(char *data, int size)
{
    DWORD nWritten;
    WriteFile(hLog, data, size, &nWritten, 0);

    if ( ((verbose&VERBOSE_FLUSHOFTEN)!=0) || (((++nlogs)&0x3f)==0) )
        FlushFileBuffers(hLog);
}
void log(char *msg, ...)
{
	WaitForSingleObject(log_mutex, INFINITE);
    va_list ap;
    char buf[1024];

    va_start(ap, msg);
	int n= _vsnprintf(buf, 1024, msg, ap);
    buf[1024]=0;
    va_end(ap);

    writelog(buf, n);
	ReleaseMutex(log_mutex);
}
int hexchar(BYTE c)
{
    return '0'+c+(c>9?7:0);
}
int hexdata(char *line, BYTE *buf, int size)
{
    for (int i=0 ; i<16 ; i++) {
        line[i*3]=' ';
        if (i<size) {
            line[i*3+1]=hexchar(buf[i]>>4);
            line[i*3+2]=hexchar(buf[i]&0xf);
        }
        else {
            line[i*3+1]=' ';
            line[i*3+2]=' ';
        }
    }
    line[48]=0;
    return 48;
}
int ascdata(char *line, BYTE *buf, int size)
{
    for (int i=0 ; i<16 ; i++) {
        if (i<size)
            line[i]=((buf[i]<32)||(buf[i]>0x7e)) ? '.' : buf[i];
        else
            line[i]=' ';
    }
    line[16]=0;
    return 16;
}
void hexdump(DWORD t, char *tag, BYTE *buf, int size)
{
    char line[128];
    for (int ofs=0 ; ofs<size ; ofs+=16) {
        int i= _snprintf(line, 128, "%08lx-%.8s %04x:", t, tag, ofs);

        i+=hexdata(line+i, buf+ofs, size-ofs);
        line[i++]=' ';
        line[i++]=' ';
        i+=ascdata(line+i, buf+ofs, size-ofs);
        line[i++]='\n';
        writelog(line, i);
    }
}
//-------------------------------------------------------------------
//typedef std::map<DWORD,struct threadinfo*> ThreadMap;
//ThreadMap threadmap;
typedef std::set<DWORD> ThreadSet;
ThreadSet threadset;

HDATA *cvHandle2HDataPtr(HANDLE h)
{
    return (HDATA *)(KData.handleBase+((DWORD)h&HANDLE_ADDRESS_MASK));
}
std::string dumpprocinfo(PROCESS*p)
{
    return stringformat("proc{%08lx  '%ls' %ls}", p->hProc, p->lpszProcName, p->pcmdline);
}
std::string dumpcallstack(CALLSTACK *p)
{
    return stringformat("cs{ret=%08lx sp=%08lx %s}", p->retAddr, p->dwPrevSP, dumpprocinfo(p->pprcLast).c_str());
}
void dumpthreadinfo(DWORD tid)
{
    if ((verbose&VERBOSE_THREADINFO)==0)
        return;
    if (threadset.find(tid)!=threadset.end())
        return;
    threadset.insert(tid);
	HDATA *pHandle= cvHandle2HDataPtr((HANDLE)tid);

	THREAD *thrd= (THREAD*)pHandle->pvObj;

    log("threadinfo %08lx->%08lx, cur=%s owner=%s\n", tid, thrd, dumpprocinfo(thrd->pProc).c_str(), dumpprocinfo(thrd->pOwnerProc).c_str());

    log("thread-callstack: ");
    for (struct CALLSTACK *ps = thrd->pcstkTop ; ps ; ps= ps->pcstkNext)
        log("%s", dumpcallstack(ps).c_str());
    log("\n");
}

//-------------------------------------------------------------------
//
// targetdev is either a devicename ( like 'RDO2:' )
// or a devicekey ( like 'Drivers\BuiltIn\QRADIO' )
static TCHAR targetdev[MAX_PATH];
static TCHAR devkey[MAX_PATH];

// data from loaded driver
devicedriver *g_drv;
//-------------------------------------------------------------------
BOOL APIENTRY DllMain( HANDLE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
                     )
{
	log_mutex = CreateMutex(NULL, FALSE, NULL);
    if (ul_reason_for_call==DLL_PROCESS_ATTACH) {
        openlog();
        log("%08lx: dllmain hm=%08lx ul=%08lx lp=%08lx\n", GetCurrentThreadId(), hModule, ul_reason_for_call, lpReserved);
    }
    else if (ul_reason_for_call==DLL_PROCESS_DETACH) {
        closelog();
    }
    dumpthreadinfo(GetCurrentThreadId());
    return TRUE;
}
//-------------------------------------------------------------------
#define MYMAGIC 0x98761234

struct read_queue_item {
	BYTE buffer[1024];
	unsigned int buffer_length;
	int source; // 1 = device , 2 = socket
};

void setup_fuzz_framework(void);
DWORD socket_thread(LPVOID parameter);
DWORD Real_Read(DWORD Handle, LPVOID pBuffer, DWORD dwNumBytes);
BOOL IOControl_orig( DWORD Handle, DWORD dwIoControlCode, PBYTE pInBuf, DWORD nInBufSize, PBYTE pOutBuf, DWORD nOutBufSize, PDWORD pBytesReturned);

#define READQ_MAX 20
struct read_queue_item readq[READQ_MAX] = {0};
int readq_add = 0;
int readq_del = 0;
HANDLE addSem;
HANDLE delSem;
HANDLE readq_mutex;
HANDLE rs_mutex;
DWORD readerHand;
int got_fake_sms;
int readq_running;
int net_running;
int started;
#define PORT 4223
int numgrp;



#define MAX_HANDLES 256
struct handle_info {
    DWORD dwMagic;
    union {
    HANDLE hTarget;
    DWORD dwTarget;
    };
    DWORD idx;
    HANDLE hLog;
    CRITICAL_SECTION lock;
    BYTE *buffer;
    BYTE *bufptr;
    BYTE *bufend;
    DWORD tLastTimestamp;
};
struct handle_info *handles[MAX_HANDLES];
BOOL CheckHandle(const char *fn,struct handle_info *hi)
{
    if (hi->dwMagic!=MYMAGIC || handles[hi->idx]!=hi) {
        log("%08lx %s: ERROR %08lx not a valid handle: magic=%08lx, idx=%d list:%08lx\n", 
                GetCurrentThreadId(),
                fn, hi, hi->dwMagic, hi->idx, (hi->idx<MAX_HANDLES)?handles[hi->idx]:0);
        SetLastError(ERROR_INVALID_HANDLE);
        return FALSE;
    }
    return TRUE;
}
void openbinlog(struct handle_info *hi)
{
    InitializeCriticalSection(&(hi->lock));
    EnterCriticalSection(&(hi->lock));
    hi->hLog= CreateFile(ToWString(stringformat("\\log-%08lx.log", hi->hTarget)).c_str(), GENERIC_WRITE, FILE_SHARE_READ, NULL, OPEN_ALWAYS, 0, NULL); 
    if (hi->hLog==INVALID_HANDLE_VALUE) {
        hi->hLog= NULL;
        LeaveCriticalSection(&(hi->lock));
        return;
    }
    if (verbose&VERBOSE_MEMBUFFER) {
        hi->buffer= (BYTE*)LocalAlloc(LMEM_FIXED, BINLOGBUFFERSIZE);
        hi->bufptr= hi->buffer;
        if (hi->buffer) {
            hi->bufend= hi->buffer+ BINLOGBUFFERSIZE;
        }
        else {
            hi->bufend= NULL;
        }
    }
    LeaveCriticalSection(&(hi->lock));
}
void closebinlog(struct handle_info *hi)
{
    EnterCriticalSection(&(hi->lock));
    if ((verbose&VERBOSE_MEMBUFFER)!=0 && hi->buffer) {
        DWORD n;
        WriteFile(hi->hLog, hi->buffer, hi->bufptr-hi->buffer, &n, 0);
        hi->bufptr= hi->buffer;
    }
    if (hi->hLog!=NULL && hi->hLog!=INVALID_HANDLE_VALUE)
        CloseHandle(hi->hLog);
    hi->hLog= NULL;
    LeaveCriticalSection(&(hi->lock));
    DeleteCriticalSection(&(hi->lock));
}
void flushbinlog(struct handle_info *hi)
{
    EnterCriticalSection(&(hi->lock));
    if ((verbose&VERBOSE_MEMBUFFER)!=0 && hi->buffer) {
        DWORD n;
        WriteFile(hi->hLog, hi->buffer, hi->bufptr-hi->buffer, &n, 0);
        hi->bufptr= hi->buffer;
    }
    FlushFileBuffers(hi->hLog);
    LeaveCriticalSection(&(hi->lock));
}

#define LOGTYPE_WRITE  0
#define LOGTYPE_READ   1
#define LOGTYPE_STAMP  2
void binarylog(struct handle_info *hi, DWORD tick, DWORD type, BYTE *data, DWORD size);
void logtimestamp(struct handle_info *hi)
{
    SYSTEMTIME st;
    DWORD t= GetTickCount();
    if (t-hi->tLastTimestamp < TIMESTAMP_INTERVAL)
        return;
    GetSystemTime(&st);
    binarylog(hi, t, LOGTYPE_STAMP, (BYTE*)&st, sizeof(st));
    hi->tLastTimestamp= t;
}
void binarylog(struct handle_info *hi, DWORD tick, DWORD type, BYTE *data, DWORD size)
{
    DWORD n;
    if (hi->hLog==NULL)
        return;
    EnterCriticalSection(&(hi->lock));
    if ((verbose&VERBOSE_MEMBUFFER)!=0 && hi->buffer) {
        if (hi->bufptr+12+size<hi->bufend) {
            memcpy(hi->bufptr, &tick, sizeof(DWORD));
            hi->bufptr+=sizeof(DWORD);
            memcpy(hi->bufptr, &type, sizeof(DWORD));
            hi->bufptr+=sizeof(DWORD);
            memcpy(hi->bufptr, &size, sizeof(DWORD));
            hi->bufptr+=sizeof(DWORD);
            memcpy(hi->bufptr, data, size);
            hi->bufptr+=size;
        }
        // todo: log note that we stopped logging due to buffer full
    }
    else {
        WriteFile(hi->hLog, (BYTE*)&tick, sizeof(DWORD), &n, 0);
        WriteFile(hi->hLog, (BYTE*)&type, sizeof(DWORD), &n, 0);
        WriteFile(hi->hLog, (BYTE*)&size, sizeof(DWORD), &n, 0);
        WriteFile(hi->hLog, data, size, &n, 0);
    }
    LeaveCriticalSection(&(hi->lock));
    if (type!=LOGTYPE_STAMP)
        logtimestamp(hi);
}

//-------------------------------------------------------------------
DWORD Init( DWORD dwContext)
{
	setup_fuzz_framework();

	//log("init enter\n");
    // todo: change this to:
    // HKEY hDevkey= OpenDeviceKey(dwContext);
    // ReadRegistryString(hDevkey, NULL, _T("target"), targetdev, MAX_PATH)
    if (!ReadRegistryString(HKEY_LOCAL_MACHINE, (LPTSTR)dwContext, _T("Key"), devkey, MAX_PATH)) {
        log("%08lx Init: ERROR getting target device key from %ls\n", GetCurrentThreadId(), dwContext);
        return NULL;
    }
	//log("init 1: %ls\r", devkey);
    if (!ReadRegistryString(HKEY_LOCAL_MACHINE, devkey, _T("target"), targetdev, MAX_PATH)) {
        log("%08lx Init: ERROR getting target device name\n", GetCurrentThreadId());
        return NULL;
    }
	//log("init 2: %ls\r", targetdev);
    if (!ReadRegistryDword(HKEY_LOCAL_MACHINE, devkey, _T("verbose"), &verbose))
        verbose=0;
	//log("init verbose: %x\r", verbose); 
    if (_tcschr(targetdev, '\\')==NULL && targetdev[_tcslen(targetdev)-1]==':') {
        // is devicename ->handled by Open
        log("%08lx %08lx: Init(%ls): OK dev=%ls\n", GetCurrentThreadId(), GetTickCount(), dwContext, targetdev);
        dumpthreadinfo(GetCurrentThreadId());
        g_drv= NULL;
        return 1;
    }
    else {
		//log("init 3: %ls\n",(const TCHAR*)dwContext);
        g_drv= new devicedriver();
        if (!g_drv->load((const TCHAR*)dwContext)) {
            delete g_drv;
            g_drv= NULL;
			//log("init 3.5: fail\n");
        }
		//log("init 3.5 pass\n");
        return (DWORD)g_drv;
    }
	//log("init 4\r");
}


BOOL Close( DWORD Handle)
{
    struct handle_info *hi= (struct handle_info *)Handle;
    if (!CheckHandle("Close", hi))
        return FALSE;

    DWORD t0, t1;
    DWORD stat=ERROR_INVALID_HANDLE;
    BOOL rc=FALSE;
    if (hi->hTarget!=NULL && hi->hTarget!=INVALID_HANDLE_VALUE) {
        SetLastError(0);
        t0= GetTickCount();
        if (g_drv)
            rc= g_drv->DrvClose(hi->dwTarget);
        else
            rc= CloseHandle(hi->hTarget);
        stat=GetLastError();
        t1= GetTickCount();

        log("%08lx %08lx-%08lx Close(%08lx:%08lx) -> %08lx (stat=%08lx)\n", GetCurrentThreadId(), t0, t1, hi, hi->hTarget, rc, stat);
    }
    else {
        log("%08lx Close: ERROR handle not open: %08lx:%08lx\n", GetCurrentThreadId(), hi, hi->hTarget);
    }
    if (verbose&VERBOSE_BINARY)
        closebinlog(hi);

    handles[hi->idx]=NULL;
    LocalFree(hi);
    SetLastError(stat);
    return rc;
}
BOOL Deinit( DWORD dwContext)
{
    for(int i=0 ; i<MAX_HANDLES ; i++)
        if (handles[i])
            Close((DWORD)handles[i]);
    log("%08lx %08lx: Deinit(%08lx)\n", GetCurrentThreadId(), GetTickCount(), dwContext);
    if (g_drv) {
        delete g_drv;
    }
    return TRUE;
}
DWORD Open( DWORD dwData, DWORD dwAccess, DWORD dwShareMode)
{
	//log("open enter\r");
    // dwData is the value returned from Init
    int i;
    for(i=0 ; i<MAX_HANDLES ; i++)
        if (handles[i]==NULL)
            break;
    if (i==MAX_HANDLES) {
        log("%08lx Open: ERROR too many open files\n");
        SetLastError(ERROR_TOO_MANY_OPEN_FILES);
        return NULL;
    }
	if (i != 0)
		log("handle = %d\n", i);
    struct handle_info *hi = handles[i] = (struct handle_info *)LocalAlloc(LMEM_FIXED, sizeof(struct handle_info));
    if (hi==NULL) {
        log("%08lx Open: ERROR alloc: %08lx\n", GetCurrentThreadId(), GetLastError());
        SetLastError(ERROR_TOO_MANY_OPEN_FILES);
        return NULL;
    }
    hi->idx= i;
    hi->dwMagic= MYMAGIC;
    hi->tLastTimestamp=0;

    SetLastError(0);
    DWORD t0= GetTickCount();
    if (g_drv)
        hi->dwTarget= g_drv->open(dwAccess, dwShareMode);
    else
        hi->hTarget= CreateFile(targetdev, dwAccess, dwShareMode, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    DWORD stat= GetLastError();
    DWORD t1= GetTickCount();

    if (verbose&VERBOSE_BINARY)
        openbinlog(hi);

    log("%08lx %08lx-%08lx Open(%ls, %08lx,%08lx) -> %08lx:%08lx (stat=%08lx)\n", GetCurrentThreadId(), t0, t1, 
            targetdev , dwAccess, dwShareMode, hi, hi->hTarget, stat);
    if (hi->hTarget==INVALID_HANDLE_VALUE) {
        Close((DWORD)hi);
        hi=NULL;
    }
    dumpthreadinfo(GetCurrentThreadId());
    SetLastError(stat);

	readerHand = (DWORD) hi;
	log("open: %x\n", readerHand);
	HANDLE sth = CreateThread(NULL, NULL, socket_thread, NULL, 0, 0);

    return (DWORD)hi;
}

BOOL IOControl(DWORD Handle, DWORD dwIoControlCode, PBYTE pInBuf, DWORD nInBufSize, PBYTE pOutBuf, DWORD nOutBufSize, PDWORD pBytesReturned)
{
	BYTE fake_ioc_data[] = {0x01,0x00,0x00,0x00};
	
	if (nOutBufSize != 4) {
		return(IOControl_orig(Handle, dwIoControlCode, pInBuf, nInBufSize, pOutBuf, nOutBufSize, pBytesReturned));
	}

	Sleep(100);
	memcpy(pOutBuf, fake_ioc_data, sizeof(fake_ioc_data));
	DWORD t0= GetTickCount();
	log("IOControl: %d\n", t0);

	return 1;
}

BOOL IOControl_orig( DWORD Handle, DWORD dwIoControlCode, PBYTE pInBuf, DWORD nInBufSize, PBYTE pOutBuf, DWORD nOutBufSize, PDWORD pBytesReturned)
{
	log("iocontrol enter\r");
    struct handle_info *hi= (struct handle_info *)Handle;
    if (!CheckHandle("IOControl", hi))
        return FALSE;
    if (dwIoControlCode==0x47534d4b) {
        if (verbose&VERBOSE_BINARY)
            flushbinlog(hi);
        return TRUE;
    }
    BYTE *origInBuf= (BYTE*)LocalAlloc(LMEM_FIXED, nInBufSize);
    memcpy(origInBuf, pInBuf, nInBufSize);

    SetLastError(0);
    DWORD t0= GetTickCount();
    BOOL rc;
    if (g_drv)
        rc = g_drv->DrvIOControl(hi->dwTarget, dwIoControlCode, pInBuf, nInBufSize, pOutBuf, nOutBufSize, pBytesReturned);
    else
        rc= DeviceIoControl(hi->hTarget, dwIoControlCode, pInBuf, nInBufSize, pOutBuf, nOutBufSize, pBytesReturned, NULL);
    DWORD stat=GetLastError();
    DWORD t1= GetTickCount();

    if (1) { //verbose&VERBOSE_IOCONTROL) {
        log("%08lx %08lx-%08lx devio(%08lx:%08lx, %08lx,  %08lx, %08lx,  %08lx, %08lx,  %08lx:%d) -> %08lx ( stat=%08lx )\n", GetCurrentThreadId(),
                t0, t1,
                hi,hi->hTarget, dwIoControlCode, 
                pInBuf, nInBufSize, 
                pOutBuf, nOutBufSize, 
                pBytesReturned, pBytesReturned?*pBytesReturned:0, 
                rc, stat);

        hexdump(t0, "in0", origInBuf, nInBufSize);
        if (memcmp(origInBuf, pInBuf, nInBufSize))
            hexdump(t0, "in1", pInBuf, nInBufSize);
        hexdump(t0, "out", pOutBuf, nOutBufSize);
        dumpthreadinfo(GetCurrentThreadId());
    }
    LocalFree(origInBuf);
    SetLastError(stat);
	log("iocontrol exit\n");
    return rc;
}

DWORD Read(DWORD Handle, LPVOID pBuffer, DWORD dwNumBytes)
{
	char fake_ok[] = { 0x30, 0x0D };
	log("ReadQ...\n");

	if (got_fake_sms == 3) {
		DWORD t0= GetTickCount();
		got_fake_sms = 0;
		memcpy(pBuffer, fake_ok, sizeof(fake_ok));
		log("ReadQ: %d bytes\n---\n%s\n+++\n", 2, pBuffer);
		log("ReadQ: fake ok %d\n", t0);
		return sizeof(fake_ok);
	}

	DWORD res = 0;
	
	if (got_fake_sms != 1) {
		do {
			res = Real_Read(Handle, pBuffer, dwNumBytes);
			if (res == 0) Sleep(100);
		} while (res == 0 && got_fake_sms == 0);
	}

	if (got_fake_sms == 3) {
		DWORD t0= GetTickCount();
		got_fake_sms = 0;
		memcpy(pBuffer, fake_ok, sizeof(fake_ok));
		log("ReadQ: %d bytes\n---\n%s\n+++\n", 2, pBuffer);
		log("ReadQ: fake ok %d\n", t0);
		return sizeof(fake_ok);
	}

	WaitForSingleObject(readq_mutex, INFINITE);
	if (got_fake_sms == 1) {
		if (dwNumBytes - res >= readq[0].buffer_length) { 
			memcpy((char*)pBuffer + res, readq[0].buffer, readq[0].buffer_length); // copy buffer
			res += readq[0].buffer_length; // set num bytes
			got_fake_sms = 2;
			DWORD t0= GetTickCount();
			log("ReadQ: added fake sms %d\n", t0); 
		}
	}
	ReleaseMutex(readq_mutex);

	DWORD t0= GetTickCount();
	log("ReadQ: %d %d bytes\n---\n%s\n+++\n", t0, res, pBuffer);
	return res;
}

DWORD Real_Read(DWORD Handle, LPVOID pBuffer, DWORD dwNumBytes)
{
	//log("read enter\r");
    struct handle_info *hi= (struct handle_info *)Handle;
    if (!CheckHandle("Read", hi)) {
		log("Readl_read: error 1\n");
		return 0xFFFFFFFF;
	}

    DWORD nRead=0;

    SetLastError(0);
    DWORD t0= GetTickCount();
    BOOL rc;
    if (g_drv) {
        nRead= g_drv->DrvRead(hi->dwTarget, pBuffer, dwNumBytes);
        rc= (nRead!=0xFFFFFFFF);
    }
    else
        rc= ReadFile(hi->hTarget, pBuffer, dwNumBytes, &nRead, NULL);
    DWORD stat=GetLastError();
    DWORD t1= GetTickCount();

    if ((verbose&VERBOSE_READWRITE)==0) {
        // don't log
    }
    else if (nRead==0 && rc) {
        // don't log
    }
    else if (rc && nRead) {
/*        log("%08lx %08lx-%08lx: Read(%08lx:%08lx, %08lx, %08lx) -> %08lx, n=%08lx, stat=%08lx\n", GetCurrentThreadId(),
             t0, t1,      hi, hi->hTarget, pBuffer, dwNumBytes, rc, nRead, stat);
        hexdump(t0, "Read", (BYTE*)pBuffer, nRead);
        dumpthreadinfo(GetCurrentThreadId());
*/    }
    else if (!rc) {
/*        log("%08lx %08lx-%08lx: Read(%08lx:%08lx, %08lx, %08lx) -> %08lx, n=%08lx, stat=%08lx\n", GetCurrentThreadId(),
             t0, t1,      hi, hi->hTarget, pBuffer, dwNumBytes, rc, nRead, stat);
        dumpthreadinfo(GetCurrentThreadId());
*/    }
	//log("Readl_read: error 2\n");
    if ((verbose&VERBOSE_BINARY)!=0 && nRead)
        binarylog(hi, t0, LOGTYPE_READ, (BYTE*)pBuffer, nRead);
    SetLastError(stat);
	//log("Readl_read: error 3\n");
    if (rc) {
		//log("Readl_read: error 4\n");
		return nRead;
	}
    else {
		log("Read_read: error 5\n");
        return 0xFFFFFFFF;
	}
}
DWORD Write(DWORD Handle, LPCVOID pBuffer, DWORD dwNumBytes)
{
    struct handle_info *hi= (struct handle_info *)Handle;
    if (!CheckHandle("Write", hi))
        return 0xFFFFFFFF;
    DWORD nWritten=0;

	log("Write %d bytes\n---\n%s\n+++\n", dwNumBytes, (char*)pBuffer);

	if (got_fake_sms == 2) {
		if (strstr((char*)pBuffer, "AT+CNUM") != NULL) {
			DWORD t0= GetTickCount();
			log("Write swolloed CT+CNUM %d\n", t0);
			got_fake_sms = 3;
			return(dwNumBytes);
		}
	}

    SetLastError(0);
    DWORD t0= GetTickCount();
    BOOL rc;
    if (g_drv) {
        nWritten= g_drv->DrvWrite(hi->dwTarget, pBuffer, dwNumBytes);
        rc= (nWritten!=0xFFFFFFFF);
    }
    else
        rc= WriteFile(hi->hTarget, pBuffer, dwNumBytes, &nWritten, NULL);
    DWORD stat=GetLastError();
    DWORD t1= GetTickCount();

    if ((verbose&VERBOSE_READWRITE)==0) {
        // don't log
    }
    else {
/*        log("%08lx %08lx-%08lx: Writ(%08lx:%08lx, %08lx, %08lx) -> %08lx, n=%08lx, stat=%08lx\n", GetCurrentThreadId(),
                t0, t1, hi, hi->hTarget, pBuffer, dwNumBytes, rc, nWritten, stat);
        if (rc && nWritten)
            hexdump(t0, "Writ", (BYTE*)pBuffer, dwNumBytes);
        dumpthreadinfo(GetCurrentThreadId());
*/    }
    if (verbose&VERBOSE_BINARY)
        binarylog(hi, t0, LOGTYPE_WRITE, (BYTE*)pBuffer, dwNumBytes);
    SetLastError(stat);
    if (rc)
        return nWritten;
    else
        return 0xFFFFFFFF;

}
DWORD Seek(DWORD Handle, long lDistance, DWORD dwMoveMethod)
{
    struct handle_info *hi= (struct handle_info *)Handle;
    if (!CheckHandle("IOControl", hi))
        return 0xFFFFFFFF;

    SetLastError(0);
    DWORD t0= GetTickCount();
    DWORD rc;
    if (g_drv)
        rc= g_drv->DrvSeek(hi->dwTarget, lDistance, dwMoveMethod);
    else
        rc= SetFilePointer(hi->hTarget, lDistance, 0, dwMoveMethod);
    DWORD stat=GetLastError();
    DWORD t1= GetTickCount();

    log("%08lx %08lx-%08lx: Seek(%08lx:%08lx, %08lx, %08lx) -> %08lx, stat=%08lx\n", GetCurrentThreadId(),
            t0, t1, hi, hi->hTarget, lDistance, dwMoveMethod, rc, stat);

    SetLastError(stat);
    return rc;
}
void PowerUp(void)
{
    log("%08lx %08lx: powerup\n", GetCurrentThreadId(), GetTickCount());
    if (g_drv)
        g_drv->DrvPowerUp();
}
void PowerDown(void)
{
    log("%08lx %08lx: powerdown\n", GetCurrentThreadId(), GetTickCount());
    if (g_drv)
        g_drv->DrvPowerDown();
}

DWORD socket_thread(LPVOID parameter)
{
	SOCKET server;
	SOCKET client;
	sockaddr_in addr;
	char pBuffer[1024];
	int num;
	WSADATA	wsaData;
	char fake_ok[] = { 0x30, 0x0D };

	log("socket_thread: before WSAStartup\n");
	/* winsock setup */
	WSAStartup(MAKEWORD(1,1), &wsaData);

	log("socket_thread: START\n");

	/* do network i/o */
	server = socket(AF_INET, SOCK_STREAM, 0);
	addr.sin_port = htons(PORT);
	addr.sin_family= AF_INET;
	addr.sin_addr.s_addr = INADDR_ANY;
	bind(server, (struct sockaddr *)&addr, sizeof(addr));
	listen(server, 1);

	while (net_running) {

	client = accept(server, NULL, 0);
	//log("socket_thread: connection accepted\n");
	// read
	num = recv(client, pBuffer, sizeof(pBuffer), 0);
	if (num < 0) {
		log("socket_thread: recv failed\n");
		closesocket(client);
		client = -1;
		continue;
	}
	DWORD t0= GetTickCount();
	log("socket_thread: @%d Read: %d bytes\n---\n%s\n+++\n", t0, num, pBuffer);
	//WaitForSingleObject(addSem, INFINITE);

	WaitForSingleObject(readq_mutex, INFINITE);
	
	// fake sms
	memset(readq[0].buffer, 0, 1024);
	memcpy(readq[0].buffer, pBuffer, num); // copy buffer
	readq[0].buffer_length = num; // set num bytes
	readq[0].source = 2; // source is network
	//readq_add = (readq_add + 1) % READQ_MAX; // new add posistion

	got_fake_sms = 1;

	ReleaseMutex(readq_mutex);

	closesocket(client);
	client = -1;
	//log("socket_thread: done, disconnect\n");
	}

	return 0;
}

void setup_fuzz_framework(void)
{
	readq_add = 0;
	readq_del = 0;
	readq_running = 1;
	net_running = 1;
	started = 0;
	numgrp = 1;
	got_fake_sms = 0;
	addSem = CreateSemaphore(NULL, READQ_MAX, READQ_MAX, NULL);
	delSem = CreateSemaphore(NULL, 0, READQ_MAX, NULL);
	readq_mutex = CreateMutex(NULL, FALSE, NULL);
	rs_mutex = CreateSemaphore(NULL, 0, 1, NULL);
	
	//log("setup_fuzz_framework\n");
}
