#ifndef __DEVICEDRIVERLOADER_H__
#define __DEVICEDRIVERLOADER_H__

#include "debug.h"

typedef DWORD (*PFNInit)( DWORD dwContext);
typedef BOOL (*PFNDeinit)( DWORD dwContext);

typedef BOOL (*PFNClose)( DWORD Handle);
//BOOL WINAPI CloseHandle( HANDLE hObject); 

typedef DWORD (*PFNOpen)( DWORD dwData, DWORD dwAccess, DWORD dwShareMode);
//HANDLE WINAPI CreateFile( LPCTSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);

typedef BOOL (*PFNIOControl)( DWORD Handle, DWORD dwIoControlCode, PBYTE pInBuf, DWORD nInBufSize, PBYTE pOutBuf, DWORD nOutBufSize, PDWORD pBytesReturned);
//BOOL DeviceIoControl( HANDLE hDevice, DWORD dwIoControlCode, LPVOID lpInBuffer, DWORD nInBufferSize, LPVOID lpOutBuffer, DWORD nOutBufferSize, LPDWORD lpBytesReturned, LPOVERLAPPED lpOverlapped);

typedef DWORD (*PFNRead)(DWORD Handle, LPVOID pBuffer, DWORD dwNumBytes);
//BOOL WINAPI ReadFile( HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped);

typedef DWORD (*PFNWrite)(DWORD Handle, LPCVOID pBuffer, DWORD dwNumBytes);
//BOOL WINAPI WriteFile( HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped);

typedef DWORD (*PFNSeek)(DWORD Handle, long lDistance, DWORD dwMoveMethod);
//DWORD WINAPI SetFilePointer( HANDLE hFile, LONG lDistanceToMove, PLONG lpDistanceToMoveHigh, DWORD dwMoveMethod);

typedef void (*PFNPowerUp)(void);
typedef void (*PFNPowerDown)(void);

class devicedriver {
public:
    devicedriver() 
        : _hLib(0),
        _dwDriver(0),
        DrvInit(0),
        DrvClose(0),
        DrvDeinit(0),
        DrvOpen(0),
        DrvIOControl(0),
        DrvRead(0),
        DrvWrite(0),
        DrvSeek(0),
        DrvPowerUp(0),
        DrvPowerDown(0)
    {
        debugt("devdriver construct(%08lx)\n", this);
    }

    ~devicedriver() { debugt("devdriver destruct(%08lx)\n", this); unload(); }
    bool load(const TCHAR*driverkey);
    void unload();

    DWORD open(DWORD dwAccess, DWORD dwShareMode);
    HINSTANCE hlib() const { return _hLib; }

    HINSTANCE _hLib;

    DWORD _dwDriver;
    PFNInit      DrvInit;
    PFNClose     DrvClose;
    PFNDeinit    DrvDeinit;
    PFNOpen      DrvOpen;
    PFNIOControl DrvIOControl;
    PFNRead      DrvRead;
    PFNWrite     DrvWrite;
    PFNSeek      DrvSeek;
    PFNPowerUp   DrvPowerUp;
    PFNPowerDown DrvPowerDown;


};
#endif
