#include <windows.h>
#include "RegistryFunctions.h"
#include "devicedriverloader.h"
#include "debug.h"
#include "stringutils.h"

extern void log(char *msg, ...);

bool devicedriver::load(const TCHAR *driverkey)
{
    DWORD dwFlags=0;
    log("devdriver load(%ls)\n", driverkey);
    TCHAR drvdll[MAX_PATH] = _T("smd_com.dll");
   /* if (!ReadRegistryString(HKEY_LOCAL_MACHINE, driverkey, _T("Dll"), drvdll, MAX_PATH))
        goto errorexit;
*/
    TCHAR prefix[MAX_PATH] = _T("SMD");
/*
    if (!ReadRegistryString(HKEY_LOCAL_MACHINE, driverkey, _T("Prefix"), prefix, MAX_PATH))
        goto errorexit;
*/
    ReadRegistryDword(HKEY_LOCAL_MACHINE, driverkey, _T("Flags"), &dwFlags);
	dwFlags = 0x0C;

    log("tstdev(%ls), drvdll=%ls   prefix=%ls\n", driverkey, drvdll, prefix);
    _hLib= LoadLibrary(drvdll);
    if (_hLib==NULL || _hLib==INVALID_HANDLE_VALUE) {
        log("LoadLibrary(%ls)", drvdll);
        goto errorexit;
    }
    debug("driver dll loaded: %08lx\n", _hLib);
    //dumpdllinfo(hLib);
// loads device functions prefixed with the device name
#define LOADPREFIXPROC(n) \
    Drv##n = (PFN##n)GetProcAddress(_hLib, ToWString(stringformat("%ls_" #n, prefix)).c_str()); \
    if (Drv##n==NULL) { \
        log("GetProcAddr(%ls)", ToWString(stringformat("%ls_" #n, prefix)).c_str()); \
        goto errorexit_unloadlib; \
    }
// loads 'naked' device functions
#define LOADNOPREFIXPROC(n) \
    Drv##n = (PFN##n)GetProcAddress(_hLib, _T(#n)); \
    if (Drv##n==NULL) { \
        log("GetProcAddr(%ls)", _T(#n)); \
        goto errorexit_unloadlib; \
    }
#ifndef DEVFLAGS_NAKEDENTRIES
#define DEVFLAGS_NAKEDENTRIES 8
#endif
    if (dwFlags&DEVFLAGS_NAKEDENTRIES) {
        LOADNOPREFIXPROC(Init)
        LOADNOPREFIXPROC(Close)
        LOADNOPREFIXPROC(Deinit)
        LOADNOPREFIXPROC(Open)
        LOADNOPREFIXPROC(IOControl)
        LOADNOPREFIXPROC(Read)
        LOADNOPREFIXPROC(Write)
        LOADNOPREFIXPROC(Seek)
        LOADNOPREFIXPROC(PowerUp)
        LOADNOPREFIXPROC(PowerDown)
    }
    else {
        LOADPREFIXPROC(Init)
        LOADPREFIXPROC(Close)
        LOADPREFIXPROC(Deinit)
        LOADPREFIXPROC(Open)
        LOADPREFIXPROC(IOControl)
        LOADPREFIXPROC(Read)
        LOADPREFIXPROC(Write)
        LOADPREFIXPROC(Seek)
        LOADPREFIXPROC(PowerUp)
        LOADPREFIXPROC(PowerDown)
    }

    if (!(DrvInit && DrvClose && DrvDeinit && DrvOpen && DrvIOControl && DrvRead && DrvWrite && DrvSeek && DrvPowerUp && DrvPowerDown)) {
        log("not all driver functions loaded: DrvInit=%08lx DrvClose=%08lx DrvDeinit=%08lx DrvOpen=%08lx DrvIOControl=%08lx DrvRead=%08lx DrvWrite=%08lx DrvSeek=%08lx DrvPowerUp=%08lx DrvPowerDown\n", DrvInit,  DrvClose,  DrvDeinit,  DrvOpen,  DrvIOControl,  DrvRead,  DrvWrite,  DrvSeek,  DrvPowerUp,  DrvPowerDown);
        goto errorexit_unloadlib;
    }
    log("devicedriverloader: OK\n");
    //debug("procs loaded: init=%08lx, open=%08lx, ioctl=%08lx\n", DrvInit, DrvOpen, DrvIOControl);


    _dwDriver= DrvInit((DWORD)driverkey);
    log("init: driver=%08lx stat=%08lx\n", _dwDriver, GetLastError());

    return true;

errorexit_unloadlib:
    unload();
errorexit:
    return false;
}

void devicedriver::unload()
{
    if (_hLib==0)
        return;

    BOOL deres= DrvDeinit(_dwDriver);
    debugt("deinit: res=%08lx stat=%08lx\n", deres, GetLastError());

    debugt("devicedriverloader: freeing library\n");
    DrvInit=0;
    DrvClose=0;
    DrvDeinit=0;
    DrvOpen=0;
    DrvIOControl=0;
    DrvRead=0;
    DrvWrite=0;
    DrvSeek=0;
    DrvPowerUp=0;
    DrvPowerDown=0;
    FreeLibrary(_hLib);
    _hLib= 0;
}


DWORD devicedriver::open(DWORD dwAccess, DWORD dwShareMode)
{
    return DrvOpen(_dwDriver, dwAccess, dwShareMode);
}
