/* (C) 2003 XDA Developers  itsme@xs4all.nl
 *
 * $Header: /var/db/cvs/xda-devtools/itsutils/common/debug.h,v 1.12 2005/06/12 22:52:01 itsme Exp $
 */
#ifndef __DEBUG_H__

#include <windows.h>	// for DWORD and BYTE
#include <tchar.h>
#include "stdint.h"
#include <string>

#include "vectorutils.h"

void DebugSocketSend(const char *buf);
void debug(const char *msg, ...);
void vdebug(const char *msg, va_list ap);
void vwdebug(const WCHAR *msg, va_list ap);
void error(const char *msg, ...);
void ceerror(const char *msg, ...);
void error(DWORD dwErrorCode, const char *msg, ...);
void debugt(char *msg, ...);

class CDebugWindow  {
public:
    virtual void appendString(const TCHAR *str)=0;
};

void DebugSetLogfile(const char *filename);
void DebugSetSocket(const char *ipaddr);
void DebugRegisterWindow(CDebugWindow *wnd);
void DebugNoMessagebox();
void DebugMessagebox();
void DebugNoOutputDebugString();
void DebugOutputDebugString();
void DebugNoStdOut();
void DebugStdOut();

enum DumpUnitType {
    DUMPUNIT_BYTE=0,
    DUMPUNIT_WORD=1,
    DUMPUNIT_DWORD=2
};
inline int DumpUnitSize(DumpUnitType type) { return 1<<type; }

enum DumpFormat {
    DUMP_HEX_ASCII,     // [offset] 50 51 52 53 0d 0a 00 01  PQRS....
    DUMP_HEX,           // [offset] 50 51 52 53 0d 0a 00 01
    DUMP_ASCII,         // [offset] PQRS....
    DUMP_STRINGS,       // [offset] "PQRS",0d,0a,00,01
    DUMP_RAW,           // [offset] PQRS^M^J^@^A
    DUMP_HASH,          // just print hash of entire buffer
    DUMP_HASHES,        // print all known hash types
    DUMP_CRC32,         // print crc32 of entire buffer
    DUMP_SUM,           // print various sums of entire buffer
};
#define HEXDUMP_WITH_OFFSET    (1<<20)
#define HEXDUMP_SUMMARIZE      (1<<21)
#define HEXDUMP_MOREFOLLOWS    (1<<22)

// bits0-11 : units_per_line
// bits12-13 : unittype
// bits14-15 : ?
// bits16-19 : format
// bits20  with offset
// bits21  summarize
// bits22  morefollows
// bits23-31 : ?
inline DWORD hexdumpflags(DumpUnitType unit, int units_per_line, DumpFormat format) {
    return static_cast<DWORD>(units_per_line | (unit<<12) | (format<<16));
}
inline DumpUnitType dumpunit_from_flags(DWORD flags) { return static_cast<DumpUnitType>((flags>>12)&3); }
inline DumpFormat dumpformat_from_flags(DWORD flags) { return static_cast<DumpFormat>((flags>>16)&15); }
inline int unitsperline_from_flags(DWORD flags) { return static_cast<int>(flags&0xfff); }

void writedumpline(int64_t llOffset, const std::string& line);
void bighexdump(int64_t llOffset, const ByteVector& data, DWORD flags=hexdumpflags(DUMPUNIT_BYTE, 16, DUMP_HEX_ASCII)|HEXDUMP_WITH_OFFSET|HEXDUMP_SUMMARIZE);
void bighexdump(const ByteVector& data, DWORD flags=hexdumpflags(DUMPUNIT_BYTE, 16, DUMP_HEX_ASCII)|HEXDUMP_SUMMARIZE);

#ifdef _WIN32_WCE
bool isSmartPhone();
#endif

#define __DEBUG_H__
#endif

