#include <windows.h>
#include "RegistryFunctions.h"
#include "debug.h"

BOOL ReadRegistryString(HKEY hRoot, const TCHAR* regpath, const TCHAR* valname, TCHAR *strval, int maxlen)
{
    HKEY hKey;
    DWORD rc= RegOpenKeyEx(hRoot, regpath, 0, 0, &hKey);
    if (rc) {
        debug("RegOpenKeyEx(%ls): ERROR %08lx\n", regpath, rc);
        return FALSE;
    }

    DWORD valtype=0;
    DWORD maxsize= sizeof(TCHAR)*(maxlen-1);
    rc= RegQueryValueEx(hKey, valname, NULL, &valtype, (LPBYTE)strval, &maxsize);
    if (rc) {
        debug("RegQueryValueEx('%ls', '%ls'): ERROR %08lx\n", regpath, valname, rc);
        RegCloseKey(hKey);
        return FALSE;
    }
    strval[maxlen-1]=0;
    RegCloseKey(hKey);
    return TRUE;
}
BOOL ReadRegistryDword(HKEY hRoot, const TCHAR* regpath, const TCHAR* valname, DWORD *pvalue)
{
    HKEY hKey;
    DWORD rc= RegOpenKeyEx(hRoot, regpath, 0, 0, &hKey);
    if (rc) {
        debug("RegOpenKeyEx(%ls): ERROR %08lx\n", regpath, rc);
        return FALSE;
    }

    DWORD valtype=0;
    DWORD maxsize= sizeof(DWORD);
    rc= RegQueryValueEx(hKey, valname, NULL, &valtype, (LPBYTE)pvalue, &maxsize);
    if (rc) {
        debug("RegQueryValueEx('%ls', '%ls'): ERROR %08lx\n", regpath, valname, rc);
        RegCloseKey(hKey);
        return FALSE;
    }
    RegCloseKey(hKey);
    return TRUE;
}

