/* Copyright 2005 xda-developers.com
 * All Rights Reserved
 *
 *  $Header$
 *
 */
#ifndef __FILEFUNCTIONS_H__

#include "vectorutils.h"
#include <string>

#define AT_NONEXISTANT      1
#define AT_ISDIRECTORY      2
#define AT_ISFILE           3
int getWin32Attributes(const TCHAR *szName);

bool WriteFileData(const std::string& filename, const ByteVector& data);
bool LoadFileData(const std::string filename, ByteVector& data, DWORD dwFileOfs=0, DWORD dwRequestedSize=0xFFFFFFFF);
bool ReadDword(HANDLE f, DWORD &w);
bool ReadData(HANDLE f, ByteVector& data, DWORD size=0xFFFFFFFF);
bool WriteData(HANDLE f, const ByteVector& data);
bool WriteDword(HANDLE f, DWORD w);

#define __FILEFUNCTIONS_H__
#endif

