/* Copyright 2005 xda-developers.com
 * All Rights Reserved
 *
 *  $Header$
 *
 */
#include <windows.h>
#include "debug.h"
#include "vectorutils.h"
#include "stringutils.h"
#include "FileFunctions.h"

bool WriteFileData(const std::string& filename, const ByteVector& data)
{
    HANDLE h= CreateFile(ToTString(filename).c_str(), GENERIC_WRITE, FILE_SHARE_READ,
                NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

    if (h==INVALID_HANDLE_VALUE || h==NULL)
    {
        error("CreateFile(%hs, WRITE)", filename.c_str());
        return false;
    }
    DWORD wrote;
    if (!WriteFile(h, vectorptr(data), data.size(), &wrote, NULL))
    {
        CloseHandle(h);
        return false;
    }
    if (!CloseHandle(h))
    {
        error("WriteFileData: CloseHandle");
        return false;
    }

    return true;
}
bool LoadFileData(const std::string filename, ByteVector& data, DWORD dwFileOffset, DWORD dwRequestedSize)
{
    HANDLE h= CreateFile(ToTString(filename).c_str(), GENERIC_READ, FILE_SHARE_READ,
                NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    if (h==INVALID_HANDLE_VALUE || h==NULL)
    {
        error("CreateFile(%hs, READ)", filename.c_str());
        return false;
    }
    if (INVALID_SET_FILE_POINTER==SetFilePointer(h, dwFileOffset, NULL, FILE_BEGIN)) {
        error("SetFilePointer");
        CloseHandle(h);
        return false;
    }

    DWORD dwFileSize= GetFileSize(h, NULL);
    data.resize((dwRequestedSize==0xFFFFFFFF) || (dwRequestedSize>dwFileSize-dwFileOffset) ? dwFileSize-dwFileOffset : dwRequestedSize);

    DWORD read;
    if (!ReadFile(h, vectorptr(data), data.size(), &read, NULL))
    {
        CloseHandle(h);
        return false;
    }
    if (!CloseHandle(h))
    {
        error("LoadFileData: CloseHandle");
        return false;
    }

    return true;
}

bool ReadDword(HANDLE f, DWORD &w)
{
    DWORD read;
    if (!ReadFile(f, &w, sizeof(DWORD), &read, NULL))
    {
        error("ReadFile");
        return false;
    }
    return true;
}
bool ReadData(HANDLE f, ByteVector& data, DWORD size/*=0xFFFFFFFF*/)
{
    if (size==0xFFFFFFFF) {
        // read remaining part of file.
        size= GetFileSize(f, NULL) - SetFilePointer(f, 0, NULL, FILE_CURRENT);
    }
    data.resize(size);

    DWORD read;
    if (!ReadFile(f, vectorptr(data), size, &read, NULL))
    {
        error("ReadFile");
        return false;
    }
    return true;
}

bool WriteData(HANDLE f, const ByteVector& data)
{
    DWORD wrote;
    if (!WriteFile(f, vectorptr(data), data.size(), &wrote, NULL))
    {
        error("WriteFile");
        return false;
    }
    return true;
}
bool WriteDword(HANDLE f, DWORD w)
{
    DWORD wrote;
    if (!WriteFile(f, &w, sizeof(DWORD), &wrote, NULL))
    {
        error("WriteFile");
        return false;
    }
    return true;
}

int getWin32Attributes(const TCHAR *szName)
{
    WIN32_FIND_DATA wfd;
    HANDLE hFind = FindFirstFile( szName, &wfd);
    if (INVALID_HANDLE_VALUE == hFind)
        return AT_NONEXISTANT;

    FindClose( hFind);

    if (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
        return AT_ISDIRECTORY;

    return AT_ISFILE;
}
