/*
 *  IpHome
 *
 *  Collin R. Mulliner <collin@betaversion.net>
 *  http://www.mulliner.org/nokia770/
 *
 *  This is GPL software
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <arpa/inet.h>
#include <dirent.h>
#include <unistd.h>
#include <fcntl.h>

#define RXBYTES_FILE "/sys/class/net/%s/statistics/rx_bytes"
#define TXBYTES_FILE "/sys/class/net/%s/statistics/tx_bytes"
#define RXERR_FILE "/sys/class/net/%s/statistics/rx_errors"
#define TXERR_FILE "/sys/class/net/%s/statistics/tx_errors"
#define CARRIER_FILE "/sys/class/net/%s/carrier"

int iface_get_devices(char **ifaces, int *num)
{
	DIR *d = NULL;
	struct dirent *e = NULL;
	int i = 0;


	if ((d = opendir("/sys/class/net/")) != NULL) {
		while ((e = readdir(d)) != NULL) {
			if (e->d_name[0] == '.') continue;
			strncpy(ifaces[i], e->d_name, 10);
			i++;
			if (i >= *num) break;
		}
		closedir(d);
		*num = i;
		return(1);
	}
	else {
		*num = 0;
		return(0);
	}
}

int iface_isup(char *ifname)
{
	char devname[sizeof(CARRIER_FILE)+20];
	char buf[100];
	int fp;
	unsigned int val = 0;
	

	sprintf(devname, CARRIER_FILE, ifname);
	if ((fp = open(devname, O_RDONLY)) >= 0) {
		read(fp, buf, 100);
		sscanf(buf, "%u", &val);
		close(fp);
	}

	return(val);
}

unsigned int iface_get_addr(char *ifname)
{
	struct ifreq *ifr;
	struct ifreq ifrr;
	struct in_addr addr;
	int sock = socket(AF_INET, SOCK_DGRAM, 0);


	ifr = &ifrr;
	ifrr.ifr_addr.sa_family = AF_INET;
	strncpy(ifrr.ifr_name, ifname, sizeof(ifrr.ifr_name));

	if (ioctl(sock, SIOCGIFADDR, ifr) < 0) {
		close(sock);
		return(0);
	}

	memcpy(&addr, ifrr.ifr_addr.sa_data+2, sizeof(addr));
	//printf("Address for %s: %s\n", ifname, inet_ntoa(addr));
	close(sock);
	return(addr.s_addr);
}

char* iface_get_addr_string(char *ifname)
{
	struct in_addr addr;

	addr.s_addr = iface_get_addr(ifname);
	return(inet_ntoa(addr));
}

char* iface_get_rxbytes(char *ifname)
{
	int fp;
	char devname[sizeof(RXBYTES_FILE)+20];
	static char leng_str[20];
	unsigned int val = 0;
	char buf[100];


	sprintf(devname, RXBYTES_FILE, ifname);
	if ((fp = open(devname, O_RDONLY)) >= 0) {
		read(fp, buf, 100);
		sscanf(buf, "%u", &val);
		close(fp);
	}
	if (val > 1024*1024) {
		sprintf(leng_str, "%dM", val/(1024*1024));
	}
	else if (val > 1024) {
		sprintf(leng_str, "%dK", val/1024);
	}
	else {
		sprintf(leng_str, "%d", val);
	}
	return(leng_str);
}

char* iface_get_txbytes(char *ifname)
{
	int fp;
	char devname[sizeof(TXBYTES_FILE)+20];
	static char leng_str[20];
	unsigned int val = 0;
	char buf[100];


	sprintf(devname, TXBYTES_FILE, ifname);
	if ((fp = open(devname, O_RDONLY)) >= 0) {
		read(fp, buf, 100);
		sscanf(buf, "%u", &val);
		close(fp);
	}
	if (val > 1024*1024) {
		sprintf(leng_str, "%dM", val/(1024*1024));
	}
	else if (val > 1024) {
		sprintf(leng_str, "%dK", val/1024);
	}
	else {
		sprintf(leng_str, "%d", val);
	}
	return(leng_str);
}

char *iface_get_txerr(char *ifname)
{
	int fp;
	char devname[sizeof(TXERR_FILE)+20];
	static char leng_str[20];
	unsigned int val = 0;
	char buf[100];


	sprintf(devname, TXERR_FILE, ifname);
	if ((fp = open(devname, O_RDONLY)) >= 0) {
		read(fp, buf, 100);
		sscanf(buf, "%u", &val);
		close(fp);
	}
	sprintf(leng_str, "%d", val);
	return(leng_str);
}

char *iface_get_rxerr(char *ifname)
{
	int fp;
	char devname[sizeof(RXERR_FILE)+20];
	static char leng_str[20];
	unsigned int val = 0;
	char buf[100];


	sprintf(devname, RXERR_FILE, ifname);
	if ((fp = open(devname, O_RDONLY)) >= 0) {
		read(fp, buf, 100);
		sscanf(buf, "%u", &val);
		close(fp);
	}
	sprintf(leng_str, "%d", val);
	return(leng_str);
}
