/*
 *  IpHome
 *
 *  Collin R. Mulliner <collin@betaversion.net>
 *  http://www.mulliner.org/nokia770/
 * 
 * This is GPL software
 *
 */ 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>

#include <glib.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>
//#include <hildon-home-plugin/hildon-home-plugin-interface.h>
//#include <hildon-widgets/gtk-infoprint.h>
#include <libosso.h>

#include "net.h"

#define PACKAGE_VERSION "1.0"

typedef struct
{
	osso_context_t *ctxt;

	GtkWidget *frame;
	GtkWidget *hbox;
	GtkWidget *hbox2;
	GtkWidget *vbox;
	GtkWidget *iplabel;
	GtkWidget *txlabel;
	GtkWidget *rxlabel;
	GtkWidget *txelabel;
	GtkWidget *rxelabel;
	GtkWidget *button;

	guint timer;
	guint current_iface;

	char *current_iface_name;
	char *ifaces[10];
	guint ifaces_num;
} IpHpHomeCtx;

int get_next_iface(int current, IpHpHomeCtx *ctx)
{
	char *iface;
	int i;


	ctx->ifaces_num = 10;
	if (iface_get_devices((char**)ctx->ifaces, &ctx->ifaces_num)) {
#ifdef DEBUG
		int i2;
		for (i2 = 0; i2 < ctx->ifaces_num; i2++) {
		       fprintf(stderr, "[%d] %s\n", i2, ctx->ifaces[i2]);
		}
#endif
	}	
	else {
#ifdef DEBUG
		fprintf(stderr, "no ifaces found, where is lo?\n");
#endif
	}

	i = current % ctx->ifaces_num;
	iface = (char*) ctx->ifaces[i];
	while (iface_get_addr(iface) == 0 || (!iface_isup(iface))) {
		i = (i+1) % ctx->ifaces_num;
		iface = (char*) ctx->ifaces[i];
	}
	return(i);
}

static gboolean iphome_iface_select_press(GtkWidget *widget, GdkEvent *event, IpHpHomeCtx *ctx)
{

	ctx->current_iface = get_next_iface(ctx->current_iface + 1, ctx);
	ctx->current_iface_name = ctx->ifaces[ctx->current_iface];
	update(ctx);

	return(TRUE);
}

void* hildon_home_applet_lib_initialize(void *state_data, int *state_size, GtkWidget **applet_return)
{
	int i;
	
	IpHpHomeCtx *ctx = g_new0(IpHpHomeCtx, 1);
	
	ctx->frame = gtk_frame_new(NULL);
	gtk_widget_show(ctx->frame);
	*applet_return = ctx->frame;
	gtk_frame_set_shadow_type(GTK_FRAME(ctx->frame), GTK_SHADOW_ETCHED_IN);

	ctx->button = gtk_event_box_new();
	gtk_widget_show(ctx->button);
	gtk_container_add(GTK_CONTAINER(ctx->frame), ctx->button);
	g_signal_connect(ctx->button, "button-press-event", G_CALLBACK(iphome_iface_select_press), ctx);

	ctx->vbox = gtk_vbox_new(FALSE, 1);
	gtk_widget_show(ctx->vbox);
	gtk_container_add(GTK_CONTAINER(ctx->button), ctx->vbox);

	ctx->iplabel = gtk_label_new("XXX");
	gtk_widget_show(ctx->iplabel);
	gtk_label_set_justify(GTK_LABEL(ctx->iplabel), GTK_JUSTIFY_FILL);
	gtk_container_add(GTK_CONTAINER(ctx->vbox), ctx->iplabel);

	ctx->hbox = gtk_hbox_new(FALSE, 1);
	gtk_widget_show(ctx->hbox);
	gtk_container_add(GTK_CONTAINER(ctx->vbox), ctx->hbox);
	ctx->txlabel = gtk_label_new("XXX");
	gtk_widget_show(ctx->txlabel);
	gtk_label_set_justify(GTK_LABEL(ctx->txlabel), GTK_JUSTIFY_FILL);
	gtk_container_add(GTK_CONTAINER(ctx->hbox), ctx->txlabel);
	ctx->rxlabel = gtk_label_new("XXX");
	gtk_widget_show(ctx->rxlabel);
	gtk_label_set_justify(GTK_LABEL(ctx->rxlabel), GTK_JUSTIFY_FILL);
	gtk_container_add(GTK_CONTAINER(ctx->hbox), ctx->rxlabel);

	ctx->hbox2 = gtk_hbox_new(FALSE, 1);
	gtk_widget_show(ctx->hbox2);
	gtk_container_add(GTK_CONTAINER(ctx->vbox), ctx->hbox2);
	ctx->txelabel = gtk_label_new("XXX");
	gtk_widget_show(ctx->txelabel);
	gtk_label_set_justify(GTK_LABEL(ctx->txelabel), GTK_JUSTIFY_FILL);
	gtk_container_add(GTK_CONTAINER(ctx->hbox2), ctx->txelabel);
	ctx->rxelabel = gtk_label_new("XXX");
	gtk_widget_show(ctx->rxelabel);
	gtk_label_set_justify(GTK_LABEL(ctx->rxelabel), GTK_JUSTIFY_FILL);
	gtk_container_add(GTK_CONTAINER(ctx->hbox2), ctx->rxelabel);

	ctx->ctxt = osso_initialize ("iphome_home", PACKAGE_VERSION, FALSE, NULL);

	ctx->timer = 0;
	ctx->current_iface = 0;
	for (i = 0; i < 10; i++) {
		ctx->ifaces[i] = g_malloc0(11);
	}
	ctx->current_iface = get_next_iface(ctx->current_iface, ctx);
	ctx->current_iface_name = ctx->ifaces[ctx->current_iface];

#ifdef DEBUG	
	fprintf(stderr, "initialize\n");
#endif
	return(ctx);
}

int hildon_home_applet_lib_get_requested_width(IpHpHomeCtx *ctx)
{
#ifdef DEBUG	
	fprintf (stderr, "get width\n");
#endif

	GtkRequisition req;
	gtk_widget_size_request(ctx->frame, &req);

	return(req.width);
}

int hildon_home_applet_lib_save_state(IpHpHomeCtx *ctx, void **state_data, int *state_size)
{
#ifdef DEBUG	
	fprintf (stderr, "save_state\n");
#endif
	return(0);
}

void hildon_home_applet_lib_background(IpHpHomeCtx *ctx)
{
#ifdef DEBUG	
	fprintf (stderr, "background\n");
#endif
	if (ctx->timer) {
		g_source_remove(ctx->timer);
		ctx->timer = 0;
	}
}

gboolean update(IpHpHomeCtx *ctx);

void hildon_home_applet_lib_foreground(IpHpHomeCtx *ctx)
{
#ifdef DEBUG	
	fprintf (stderr, "foreground\n");
#endif
	if (!ctx->timer) {
		update(ctx);
		ctx->timer = g_timeout_add(1000, (GSourceFunc)update, (gpointer)ctx);
	}
}

gboolean update(IpHpHomeCtx *ctx)
{
	gchar *text = NULL;
	char *iface;


	iface = ctx->current_iface_name;

	if (!iface_isup(iface)) {
		ctx->current_iface = get_next_iface(0, ctx);
		ctx->current_iface_name = ctx->ifaces[ctx->current_iface];
	}

#ifdef DEBUG	
	fprintf(stderr, "updated called\n");
#endif
	text = g_strdup_printf("%s: %s", iface, iface_get_addr_string(iface));
	gtk_label_set_text(GTK_LABEL(ctx->iplabel), text);
	g_free(text);
	text = g_strdup_printf("RX: %s", iface_get_rxbytes(iface));
	gtk_label_set_text(GTK_LABEL(ctx->rxlabel), text);
	g_free(text);
	text = g_strdup_printf("TX: %s", iface_get_txbytes(iface));
	gtk_label_set_text(GTK_LABEL(ctx->txlabel), text);
	g_free(text);
	text = g_strdup_printf("Err TX: %s", iface_get_txerr(iface));
	gtk_label_set_text(GTK_LABEL(ctx->txelabel), text);
	g_free(text);
	text = g_strdup_printf("RX: %s", iface_get_rxerr(iface));
	//text = g_strdup_printf("%d %d", ctx->ifaces_num, ctx->current_iface);
	gtk_label_set_text(GTK_LABEL(ctx->rxelabel), text);
	g_free(text);

	return(TRUE);
}

GtkWidget* hildon_home_applet_lib_properties(IpHpHomeCtx *ctx, GtkWindow *parent)
{
#ifdef DEBUG	
	fprintf (stderr, "properties\n");
#endif
	return(NULL);
}

void hildon_home_applet_lib_deinitialize(IpHpHomeCtx *ctx)
{
	int i;

	hildon_home_applet_lib_background(ctx);
	osso_deinitialize(ctx->ctxt);
	g_free (ctx);

	for (i = 0; i < 10; i++) {
		g_free(ctx->ifaces[i]);
	}

#ifdef DEBUG	
	fprintf (stderr, "deinitialize\n");
#endif
}
