/**
 *  @file util.c
 *
 *  btfs - Bluetooth FileSystemMapping
 *
 *  @author Collin R. Mulliner <collin@betaversion.net>
 *
 *  (c) Collin R. Mulliner
 *
 *  web: www.mulliner.org/bluetooth/btfs.php
 */

/*
 * This file is part of btfs
 *
 * btfs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * btfs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with btfs; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "btfs.h"

char* getFileName(const char *name)
{
	char *f;
	
	
	f = strrchr(name, '/');
	if (f != NULL) return(f+1);
	else return(NULL);
}

int getDirName(const char *name, char *outname)
{
	char *f;
	
	
	f = strrchr(name, '/');
	if (f != NULL) {
		strncpy(outname, name, strlen(name)-strlen(f));
		return(1);
	}
	return(0);
}

int isValidName(btfs *self, char *path)
{
	int i;
	

	for (i = 0; i < self->device_list.num; i++) {
		if (strcmp(self->device_list.list[i].name, path) == 0) {
			return(1);
		}
	}
	
	return(0);
}

int isValidAddr(btfs *self, char *path)
{
	int i;
	

	for (i = 0; i < self->device_list.num; i++) {
		if (strcmp(self->device_list.list[i].bdaddr_str, path) == 0) {
			return(1);
		}
	}
	
	return(0);
}

int addFileOperation(bt_device *dev, bt_file_operation *op)
{
	if (dev->ops == NULL) {
		dev->ops = op;
		return(1);
	}
	else {
		return(0);
	}
}

int getDeviceByPath(btfs *self, char *path, bt_device **dev)
{
	int i;

		
	for (i = 0; i < self->device_list.num; i++) {
		if (strcmp(self->device_list.list[i].name, path) == 0) {
			*dev = &self->device_list.list[i];
			return(1);
		}
	}
	
	return(0);
}
