/**
 *  @file btfs.h
 *
 *  btfs - Bluetooth FileSystemMapping
 *
 *  @author Collin R. Mulliner <collin@betaversion.net>
 *
 *  (c) Collin R. Mulliner
 *
 *  web: www.mulliner.org/bluetooth/btfs.php
 */

/*
 * This file is part of btfs
 *
 * btfs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * btfs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with btfs; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#define _GNU_SOURCE
#include <time.h>
#include <pthread.h>
#include <errno.h>
#include <fcntl.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <termios.h>
#include <unistd.h>

#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>
#include <bluetooth/hci_lib.h>
#include <bluetooth/sdp.h>
#include <bluetooth/sdp_lib.h>
#include <bluetooth/rfcomm.h>

#ifndef __BTFS_H__
#define __BTFS_H__

/*
 *
 * /
 *
 * /CFG/
 * /CFG/inquiry_duration		RW
 * /CFG/cache_time				RW
 *
 * /DEVICE/					R
 * /DEVICE/bdaddrN/		RW
 *
 * /OPUSH/					R
 * /OPUSH/nameN/			RW
 * /
 *
 *
 */

enum operation_type {
	first = 0,
	obexPUT,
	last = 255
};

typedef struct bt_fo_obex_put_t {

	char name[256];
	unsigned long size;
	int state;
	unsigned char *data;
	
} bt_fo_obex_put;

typedef struct bt_file_operation_t bt_file_operation;

struct bt_file_operation_t {

	int otype;
	union {
		bt_fo_obex_put obexPUT;
	} op;

	bt_file_operation *next;
};

typedef struct bt_device_t bt_device;

struct bt_device_t {

	bdaddr_t addr;
	int obex_channel;
	char name[250];
	char bdaddr_str[19];

	bt_file_operation *ops;
};

typedef struct bt_dev_list_t {

	int num;
	time_t when;
	bt_device *list;

	pthread_rwlock_t lock;

} bt_dev_list;

typedef struct btfs_t {

	bdaddr_t local;
	
	pthread_mutex_t cfg_lock;
	int inquiry_duration;
	int cache_time;
	
	int max_devices;
	bt_dev_list device_list;
	
} btfs;

#endif
